﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class CarsConfiguration : ConfigurationElement
{
    public int PriceRoundFactor { get; private set; }
    public int GenerateAmount { get; private set; }
    public int StatsDecimalPlaces { get; private set; }
    public CarsClassConfiguration LowEnd { get; private set; }
    public CarsClassConfiguration MediumEnd { get; private set; }
    public CarsClassConfiguration HighEnd { get; private set; }

    public CarsConfiguration() : base("Cars")
    {
        
    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            PriceRoundFactor = Convert.ToInt32(configElem.Element("PriceRoundFactor").Value);
            GenerateAmount = Convert.ToInt32(configElem.Element("GenerateAmount").Value);
            StatsDecimalPlaces = Convert.ToInt32(configElem.Element("StatsDecimalPlaces").Value);

            //Create our sub-configuration objects
            LowEnd = new CarsClassConfiguration("Low-End");
            MediumEnd = new CarsClassConfiguration("Medium-End");
            HighEnd = new CarsClassConfiguration("High-End");

            //Let's try to parse all of our sub configurations, passing in the corresponding parent elements
            if (LowEnd.Parse(configElem.Element("LowEnd")))
            {
                if (MediumEnd.Parse(configElem.Element("MediumEnd")))
                {
                    if (HighEnd.Parse(configElem.Element("HighEnd")))
                    {
                        return true;    //Parsed everything successfully!
                    }

                    else
                    {
                        Debug.LogError("ERROR: Failed to parse high-end cars configuration. Perhaps the XML is malformed?");
                    }
                }

                else
                {
                    Debug.LogError("ERROR: Failed to parse medium-end cars configuration. Perhaps the XML is malformed?");
                }
            }

            else
            {
                Debug.LogError("ERROR: Failed to parse low-end cars configuration. Perhaps the XML is malformed?");
            }

            return false;   //We must have failed to parse one of the configurations
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing cars configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
